%% Function to import an obj
% Giulio Antonutto / ARUP / October 2008 
% CODE IS BETA! USE AT YOUR OWN RISK.
% Based on previous work by:
% W.S. Harwin, University Reading, 2006
% See also Anders Sandberg's vertface2obj.m and saveobjmesh.m
% This modified version exports vertex coordinates and UV coordinates for triangles.


function [PP,QQ, E]=load_obj_c4d(file)
if nargin <1 
  disp('specify model name')  
end


V = [];
VT = [];

F3v = [];
F3t = [];

F4v = [];
F4t = [];
%%
% Output is:
%
% * VT, coorfinate for textures
% * V, coordinate for vertex
% * F3v, connections for triangles
% * F4t, connections for UV triangles
% * F4v, connection for quads
% * F4t, connection for UV quads
%
% 

%%
% open and scan the file with format and get cell array with the 13 values
%file = 'testUV2.obj';
fid = fopen(file,'r');
if (fid<0) error(['Can not open the .obj file: ' file]);end


%%
% define some counters
vnum=1;
f3num=1;
f4num=1;
vtnum=1;
vnum=1;
gnum=1;

%%
% Scan lines which are not empty
cline=fgets(fid);
while cline>=0
  cline = deblank(cline);
  cline = deblank(cline);
  cline = deblank(cline);
  s = sscanf(cline,'%s',1);
  l=length(cline);
  if l==0  
%%
% Line is  empty 
    disp(['empty' cline]);
  end

%%
% if the line is not empty start reading file for different cases:
    switch s
%%
% These are comments
    case '#' 
        disp(['Skipping: ' cline]);
%%
% These are vertexes and are collected into V
      case 'v' 
          v=sscanf(cline(2:l),'%f');      
          V(:,vnum)=v;      
          vnum=vnum+1;
%%
% textures
      case 'vt' 
%%
% scan from char 3 to L, end of line
         vt=sscanf(cline(3:l),'%f');      
         VT(:,vtnum)=vt;      
         vtnum=vtnum+1;
%%       
% mesh or nurbs, just ignore
      case 'g'       
            disp(['Skipping: ' cline]);
%%
% Material of object, this need improvement
%%
% *NOTE: NOW ALL WORKS ONLY WITH ONLY ONE MATERIAL*
      case 'usemtl' 
            disp(['Skipping: ' cline]);
%%
% Normals - ignored
        case 'vn'      
            if vnnum==1 
            disp(cline);
            vnnum=vnnum+1;
            end

%%
% Faces
        case 'f' 
%%
% remove trailing zeros
      cline=deblank(cline(3:l));
%%
% count spaces, add one = vertexes
      nvrts=length(findstr(cline,' '))+1;
%%
% count slashes
      fstr=findstr(cline,'/');
      nslash=length(fstr);

      if nvrts == 3
%%
% Case with vertex and textures
         if nslash ==3
%%
% scan for vertex
             f1=sscanf(cline,'%f/%f');
          f1=f1([1 3 5]);
%%
% scan for UV vertex
          f2=sscanf(cline,'%f/%f');
          f2=f2([2 4 6]);
%%
% case with vertex, textures and normals,
        elseif nslash==6  
          f1=sscanf(cline,'%f/%f/%f');
          f1=f1([1 4 7]);
          f2=sscanf(cline,'%f/%f/%f');         
          f2=f2([2 5 8]);
         elseif nslash==0
          f1=sscanf(cline,'%f');
        else
          disp(['xyx' cline])
          f1=[];
          f2=[];
         end
%%
% The output for vertex connections
        F3v(:,f3num)=f1;
        F3t(:,f3num)=f2;
        f3num=f3num+1;
      
      
%%
% Same but for quads, which are not supported by the Radiance
% interface
      elseif nvrts == 4
        if nslash == 4
          f1=sscanf(cline,'%f/%f');
          f1=f1([1 3 5 7]);
          f2=sscanf(cline,'%f/%f');
          f2=f2([2 4 5 8]);
        elseif nslash == 8
          f1=sscanf(cline,'%f/%f/%f');
          f1=f1([1 4 7 10]);
          f2=sscanf(cline,'%f/%f/%f');
          f2=f2([2 6 8 11]);
        elseif nslash ==0
          f1=sscanf(cline,'%f');
        else
          disp(['xx' cline])
          f1=[];
          f2=[];
        end
        F4v(:,f4num)=f1;
        F4t(:,f4num)=f2;
        f4num=f4num+1;
      end 
     
    otherwise 
      if ~strcmp(cline,char([13 10]))
        disp(['Unprocessed: ' cline]);
      end
    end
     
       cline=fgets(fid);
end

fclose(fid);



PP = VT(1:3,F3t)';


QQ0 = V(1:3,F3v)';
PER = [1 0 0; 0 0 -1; 0 1 0];
QQ1 = PER*QQ0';
QQ = QQ1';

E = 0;
if (isempty(PP)==1) E = 1;end


